/*
 * Decompiled with CFR 0.152.
 */
package de.winniepat.winnieclient.utils;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public abstract class Manager<T, S> {
    protected final ConcurrentHashMap<T, S> entries = new ConcurrentHashMap();

    public boolean register(@NotNull T key, @NotNull S value) {
        return this.entries.putIfAbsent(key, value) == null;
    }

    public boolean unregister(@NotNull T key) {
        return this.entries.remove(key) != null;
    }

    @NotNull
    public S get(@NotNull T key) {
        return this.entries.get(key);
    }

    public boolean contains(@NotNull T key) {
        return this.entries.containsKey(key);
    }

    public Collection<S> values() {
        return this.entries.values();
    }

    public Set<Map.Entry<T, S>> entries() {
        return this.entries.entrySet();
    }

    public Set<T> keys() {
        return this.entries.keySet();
    }
}

